/*
 Copyright (c) 2001 
 Author: Konstantin Boukreev 
 E-mail: konstantin@mail.primorye.ru 

 Created: 02.11.2001 14:36:27
 Version: 1.0.0

*/

#ifndef _GestureData_5e525b2b_09ab_4246_b72a_da99c2fb07d7
#define _GestureData_5e525b2b_09ab_4246_b72a_da99c2fb07d7

#if _MSC_VER > 1000 
#pragma once
#endif // _MSC_VER > 1000

#define RANGE_SIZE			16
#define NET_INPUT_SIZE		(RANGE_SIZE*2)
#define NET_OUTPUT_SIZE		29
#define NUMBER_OF_PATTERNS	NET_OUTPUT_SIZE

const float pattern_data[NUMBER_OF_PATTERNS][RANGE_SIZE] = 
{
	180., 180., 180., 180., 180., 180., 180., 180., 180., 180., 180., 180., 180., 180., 180., 180.,// "up"
	0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., // "down"	
	180., 180., 180., 180., 180., 180., 180., 180., 0., 0., 0., 0., 0., 0., 0., 0., // "up-down"
	0., 0., 0., 0., 0., 0., 0., 0.,  180., 180., 180., 180., 180., 180., 180., 180., // "down-up"	
	90., 90., 90., 90., 90., 90., 90., 90., 90., 90., 90., 90., 90., 90., 90., 90., // "right"
	270., 270., 270., 270., 270., 270., 270., 270., 270., 270., 270., 270., 270., 270., 270., 270., // "left"
	90., 90., 90., 90., 90., 90., 90., 90., 270., 270., 270., 270., 270., 270., 270., 270., // "right-left"
	270., 270., 270., 270., 270., 270., 270., 270., 90., 90., 90., 90., 90., 90., 90., 90., // "left-right"
	0., 0., 0., 0., 0., 0., 0., 0., 90., 90., 90., 90., 90., 90., 90., 90., // "down-right"
	180., 180., 180., 180., 180., 180., 180., 180., 270., 270., 270., 270., 270., 270., 270., 270., //  "up-left"
	0., 0., 0., 0., 90., 90., 90., 90., 180., 180., 180., 180., 270., 270., 270., 270., // "rectangle"
	0., 0., 0., 0., 0., 0., 0., 0., 270., 270., 270., 270., 270., 270., 270., 270., // "down-left"
	180., 180., 180., 180., 180., 180., 180., 180., 90., 90., 90., 90., 90., 90., 90., 90., // "up-right"
	300., 300., 300., 300., 300., 300., 300., 300., 60., 60., 60., 60., 60., 60., 60., 60., // "left arrow"
	60., 60., 60., 60., 60., 60., 60., 60., 300., 300., 300., 300., 300., 300., 300., 300., // "right arrow"	
//	90., 90., 90., 90., 90., 315., 315., 315., 315., 315., 315., 90., 90., 90., 90., 90., // "zigzag"
	90., 90., 90., 90., 90., 310., 310., 310., 310., 310., 310., 90., 90., 90., 90., 90., // "zigzag"
	45., 45., 45., 45., 45., 45., 45., 45., 135., 135., 135., 135., 135., 135., 135., 135., // "down arrow"
	135., 135., 135., 135., 135., 135., 135., 135., 45., 45., 45., 45., 45., 45., 45., 45., // "up arrow"	
	0., 0., 0., 0., 0., 0., 225., 225., 225., 225., 90., 90., 90., 90., 90., 90., // "down-left cross"
	0., 0., 0., 0., 0., 0., 135., 135., 135., 135., 270., 270., 270., 270., 270., 270., // "down-right cross"
	180., 270., 0., 0., 90., 90., 180., 180., 180., 270., 270., 270., 0., 0., 0., 0., // "helix"
//	315, 315., 315., 315., 315., 90., 90., 90., 90., 90., 90., 225., 225., 225., 225., 225., // "triangle"	
	323, 323., 323., 323., 323., 90., 90., 90., 90., 90., 90., 217., 217., 217., 217., 217., // "triangle"	
//	90, 90., 90., 315., 315., 315., 315., 315., 90., 90., 90., 225., 225., 225.,  225., 225., // "hour-glass"
//	90, 90., 90., 323., 323., 323., 323., 323., 90., 90., 90., 217., 217., 217.,  217., 217., // "hour-glass"
	90, 90., 90., 320., 320., 320., 320., 320., 90., 90., 90., 210., 210., 210.,  210., 210., // "hour-glass"
	180, 180., 180., 180., 180., 180., 90., 90., 90., 0., 0., 0., 0., 270.,  270., 270., // "flag"
	78.75, 56.25, 33.75, 11.25, 348.75, 326.25, 303.75, 281.25, 258.75, 236.25, 213.75, 191.25, 168.75, 146.25, 123.75, 101.25, 	// circle
	101.25, 101.25, 123.75, 168.75, 168.75, 168.75,  146.25, 123.75, 56.25, 33.75, 11.25, 11.25, 11.25, 56.25, 78.75, 78.75, // "wave"	
//	180, 180., 180., 180., 180., 45., 45., 45., 45., 45., 45., 180., 180., 180.,  180., 180., // "N"
	180, 180., 180., 180., 180., 40., 40., 40., 40., 40., 40., 180., 180., 180.,  180., 180., // "N"
	180, 180., 180., 180., 45., 45., 45., 45., 135., 135., 135., 135., 0., 0.,  0., 0., // "M"
	//	45., 45., 45., 45., 45., 135., 135., 135., 45., 45., 45., 135., 135., 135., 135., 135., // "W"
	30., 30., 30., 30., 30., 150., 150., 150., 30., 30., 30., 150., 150., 150., 150., 150., // "W"	
};

const char* const pattern_names[NUMBER_OF_PATTERNS] = 
{
	"up",
	"down",
	"up-down",
	"down-up",	
	"right",
	"left",
	"right-left",
	"left-right",
	"down-right",
	"up-left",
	"rectangle",
	"down-left",
	"up-right",
	"left arrow",
	"right arrow",
	"zigzag",	
	"down arrow",
	"up arrow",
	"down-left cross",
	"down-right cross",
	"helix",
	"triangle",	
	"hour-glass",
	"flag",
	"circle",
	"wave",
	"N",
	"M",	
	"W",
};


#endif //_GestureData_5e525b2b_09ab_4246_b72a_da99c2fb07d7

