from scipy.fftpack import fft, fftfreq, fftshift
import numpy as np
from matplotlib import pyplot as plt
N = 400 # toplam nokta sayisi
T = 1.0 / 800. #noktalar arasi uzaklik
x = np.linspace(0.0, N*T, N)
y = np.exp(50.0 * 1.j * 2.0*np.pi*x) + 0.5*np.exp(-80.0 * 1.j * 2.0*np.pi*x)
yf = fft(y)
xf = fftfreq(N, T)# Frekans tanim kumesinde noktalarin uzakligi = 1 / (T*N)
xf = fftshift(xf) # 0'i guc spektrumunun ortasina aliyoruz.
yplot = fftshift(yf) # xf ile ayni ozellige sahip olmasi icin
import matplotlib.pyplot as plt
plt.plot(xf, 1.0/N * np.abs(yplot))
plt.grid()
plt.show()
