from scipy fftpack import fft
import numpy as np
from matplotlib import pyplot as plt
N = 600 # toplam nokta sayisi
T = 1.0 / 800. #noktalar arasi uzaklik
y = np.linspace(0.0, N*T, N)
yf = fft(y) # y fonksiyonunun hizli fourier donusumu
xf = np.linspace(0.0, 1.0/(2.0*T), N/2) # x'in frekansa donusumu
plt.plot(xf, 2.0/N * np.abs(yf[0:N/2])) # sadece pozitif frekanslari cizdirelim
plt.grid()
plt.show()
