"""
Komplike Bir Fonksiyonun Fourier Serisi isimli ornekteki 
f(t) fonksiyonunun numerik integralini hesaplayarak 
Fourier katsayilarini bulan kod
"""
import numpy as np
from math import pi
# Temel donem
T = 2
# Zamanda artis miktari
delT = 0.001
# t (zaman) ekseni
t = np.arange(-1,1,delT)
# g(t) fonksiyonu
gt = (t-1)*(t+1)*(2*t)**4*1./np.cos(t*1.4) + 10*np.exp(-9*t**2)
# c0 katsayisinin hesabi
c0 = 1./T*np.sum(gt*delT)
# Diger katsayilarin (c1, c2, ... , cn) sayisi (n)
numN = 30
cn = np.zeros(numN,dtype=float)
c_n = np.zeros(numN,dtype=float)
j = np.array([0+1j])
for i in range(1,numN):
    # cn hesabi icin gerekli sureksiz integral(toplam)
    cn[i] = delT/T*np.sum(gt*np.exp(-j*2*pi*i*t/T))
    # c_n hesabi icin gerekli sureksiz integral(toplam)
    c_n[i] = delT/T*np.sum(gt*np.exp(j*2*pi*i*t/T))
print cn
print c_n
