import matplotlib.pyplot as plt
import numpy as np

Fs = 150.0;  # ne siklikta nokta alindigi (sampling rate)
Ts = 1.0/Fs; # aralik uzunlugu (sampling interval)
t = np.arange(0,1,Ts) # zaman tanim kumesi (x-ekseni)

ff = 5;   # Sinaylin frekansi
y = np.sin(2*np.pi*ff*t) # sinyal

n = len(y) # sinyal uzunlugu
k = np.arange(n) # n uzunlugunda tam sayilardan olusan dizi
T = n/Fs # donem
frq = k/T # negatif ve pozitif frekanslar
frq = frq[range(n/2)] # sadece pozitif frekanslar

Y = np.fft.fft(y)/n # FFT ve n ile normalizasyon
Y = Y[range(n/2)]

fig, ax = plt.subplots(2, 1)
ax[0].plot(t,y)
ax[0].set_xlabel('Zaman')
ax[0].set_ylabel('Genlik')
ax[1].plot(frq,abs(Y),'r') # guc spektrumu
ax[1].set_xlabel('Frekans (Hz)')
ax[1].set_ylabel('|Y(frekans)|')
plt.show()
