from numpy import fft
import numpy as np
import matplotlib.pyplot as plt
# Veri noktasi sayisi
n = 1000
# Metre cinsinden noktalar arasi uzaklik
dx = 5.0
# x koordinatlari
x = dx*np.arange(0,n)
w1 = 100.0 # dalgaboyu (m)
w2 = 20.0 # dalgaboyu 2 (m)
fx = np.sin(2*np.pi*x/w1) + 2*np.cos(2*np.pi*x/w2) # sinyal
Fk = fft.fft(fx)/n # fourier katsayilari (n'e bolundugune dikkat!)
nu = fft.fftfreq(n,dx) # Frekanslar
Fk = fft.fftshift(Fk) # O'i merkeze kaydirma
nu = fft.fftshift(nu) # dogal frekansa kaydirma
f, ax = plt.subplots(3,1,sharex=True)
ax[0].plot(nu, np.real(Fk)) # kosinuslu (reel) terimler
ax[0].set_ylabel(r'$Re[F_k]$', size = 'x-large')
ax[1].plot(nu, np.imag(Fk)) # sinuslu (imajiner) terimler
ax[1].set_ylabel(r'$Im[F_k]$', size = 'x-large')
ax[2].plot(nu, np.absolute(Fk)**2) # Guc spektrumu
ax[2].set_ylabel(r'$\vert F_k \vert ^2$', size = 'x-large')
ax[2].set_xlabel(r'$\widetilde{\nu}$', size = 'x-large')
plt.show()
